import {
  DataSourceSchemaData,
  EntityAttrSchemaData,
  IconSchemaData,
  MultiAttrSchemaDataWith,
  PackMultiAttrSchemaDataWith,
  PageEventSchemaData,
  ResourceFileSchemaData,
  SizeSchemaData,
  StaticValueSchemaData,
  TemplateSchemaData,
} from '../schema/schema-data';
import { EnumValue, FILE_VALUE_TYPE, FileValue, VALUE } from './base-value';
import { EntityObject } from './entity';
import {
  ActionMeta,
  AssociationMeta,
  AttrMeta,
  DataSourceMeta,
  MultiAttrMetaWith,
  PackMultiAttrMetaWith,
  TemplateMeta,
  contextDataMeta,
} from './meta';
import { IconMeta, Size } from './style';
// 文件操作的API
export interface MediaApi {
  uploadFile: (
    file: File,
    option?: {
      onProgress: (progress: number) => void;
      type: FILE_VALUE_TYPE;
    },
  ) => Promise<FileValue>;
  createFileValue: (options: { url: string; name: string; type: FILE_VALUE_TYPE }) => FileValue;
}

// 路由API
export interface Page {}
export interface OuterPage extends Page {
  url: string;
  target?: '_parent' | '_blank';
}
export interface RouterApi {
  openPage: (
    page?: Page,
    params?: {
      contextData?: EntityObject;
      closeCallback?: (params?: any) => void;
    },
  ) => void;
  closePage: (options?: { callbackParams?: any }) => void;
}

// 导航API
export interface NavItem {
  id: string;
  title: string;
  level: number;
  children?: NavItem[];
  toPage(): Page | undefined;
}
export interface NavApi {
  getTopNavItems: () => NavItem[];
  getCurrentNavItem: () => NavItem | undefined;
  getNavPathTo: (navItem: NavItem) => NavItem[];
  onNavChange: (fn: () => void) => void;
  offNavChange: (fn: () => void) => void;
}

export interface MetaAndValueConvertApi {
  convertDataSourceMeta: (schemaData: DataSourceSchemaData) => DataSourceMeta | undefined;
  convertActionMeta: (schemaData: PageEventSchemaData) => ActionMeta;

  convertAttrMeta: ((schemaData: EntityAttrSchemaData) => AttrMeta | undefined) &
    ((attrId: string, entityId: string) => AttrMeta | undefined);
  convertMultiAttrMeta: <PackKey extends string, Config>(
    propValue: PackMultiAttrSchemaDataWith<PackKey, Config> | MultiAttrSchemaDataWith<Config>,
  ) => MultiAttrMetaWith<Config> | PackMultiAttrMetaWith<PackKey, Config> | undefined;
  convertValue: (propValue: StaticValueSchemaData | undefined) => VALUE | undefined;

  convertTemplate: (propValue: TemplateSchemaData) => TemplateMeta;

  convertAssociationMeta: (associationId: string) => AssociationMeta;

  convertSize: (propValue: SizeSchemaData) => Size;

  convertFileValue: (propValue: ResourceFileSchemaData | undefined) => FileValue | undefined;

  convertIcon: (propValue: IconSchemaData) => IconMeta;

  isFileValue: (value: any) => value is FileValue;
  isEnumValue: (value: any) => value is EnumValue;
  isValue: (value: any) => value is VALUE;
  isAttrMeta: (value: any) => value is AttrMeta;
  isTemplateMeta: (value: any) => value is TemplateMeta;
  isContextDataMeta: (value: any) => value is contextDataMeta;
}

export interface Utils {
  /**
   * DATETIME推荐的格式化方式
   * @param date
   * @returns
   */
  formatDate: (date: Date) => string;
  /**
   * 判断组件是否存在children
   * @param props 组件props
   * @returns
   */
  isChildrenEmpty: (props: { children?: React.ReactNode | undefined }) => boolean;

  /**
   * 对比api 提供的对象是否一样
   * @param left
   * @param right
   * @returns
   */
  isEqual: (left: VALUE | AttrMeta, right: VALUE | AttrMeta) => boolean;

  /**
   * 格式化模型数据，统一占位符
   * @param value
   * @returns
   */
  formatForDesignTips: (value: any) => string;

  /**
   * 主要目的是把 date 和 EnumValue FileValue, 转化为使用的 string number boolean
   * @param value 要format的数据
   * @param label 是否format为展示性的string，这里的区别主要是 FileValue 和 EnumValue， label对应 文件名，反之是文件url, 而枚举一直都是枚举的value
   * @returns
   */
  formatValue: (value: VALUE, label?: boolean) => string | number | boolean;
}

export interface Node {
  id: string;
  parent?: Node;
}
export interface DesignEngineApi {
  onSchemaChange: (fn: () => void) => void;
  offSchemaChange: (fn: () => void) => void;
  getSelected: () => Node;
  select: (node: Node | undefined) => void;
  getNodeById: (id: string) => Node | undefined;
  getNodeId: (reactNode: any) => string | undefined;
}

export interface PermissionApi {
  hasPermission: (page: Page) => boolean;
}

export type IReactComponent<P = any> =
  | React.ClassicComponentClass<P>
  | React.ComponentClass<P>
  | React.FunctionComponent<P>
  | React.ForwardRefExoticComponent<P>;
export interface ComponentApi
  extends NavApi,
    RouterApi,
    MediaApi,
    MetaAndValueConvertApi,
    Utils,
    DesignEngineApi,
    PermissionApi {
  isPreview: () => boolean;
  createMobiComponent<T extends IReactComponent>(name: string, component: T): T;
  getEnumsById: (enumTypeId: string) => EnumValue[];
}
