// 基础数据类型定义
/**
 * 魔笔系统 基础的数据类型有
 * int long decimal boolean char text datetime enum file image audio video document
 *
 */

import { ResourceFileSchemaData } from '../schema/schema-data';
import { ConvertFromSchema } from './base';

// 基础类型
export type BOOLEAN = boolean;
export type TEXT = string;
export type CHAR = string;
export type INTEGER = number;
export type LONG = number;
export type DECIMAL = number;
export type DATETIME = Date;
/**
 * 枚举数据
 * key 是 枚举的标识，枚举名，是 设计时展示用的
 * value 是 枚举的值， 是运行时 展示用的
 * 设计时 模型里应该 使用的是 枚举的key，比如表达式
 * 运行时 应该展示的是 枚举的value，比如相同的key，我们可以根据国际化的需要展示不同的值
 * 
 * enumTypeId 是枚举类型的ID，不是 这个枚举值的ID，目前系统中还没有枚举值的ID概念
 */
export interface EnumValue {
  enumTypeId: string;
  key: string;
  value: string;
  values: () => EnumValue[];
}

/**
 * {"name":"词云.jpg","oss_url":"https://mobi-app-pre-preview.oss-cn-hangzhou.aliyuncs.com/file/12719985/2023-04-18/f0e4051493f94fa29cc396d19fbf0ec3","show_url":"https://static-cluster-stage-preview.mobiapp.cloud/file/12719985/2023-04-18/f0e4051493f94fa29cc396d19fbf0ec3?Expires=1681825936&OSSAccessKeyId=LTAI4G79M18aySHdG6xBUzNB&Signature=L%2B37K2HyBu8vIS38GUam%2FBkzuz8%3D","type":"FILE"}
 * {"name":"MOBI平台问题收集单.xlsx","oss_url":"https://mobi-app-pre-preview.oss-cn-hangzhou.aliyuncs.com/file/12719985/2023-04-18/ce4234bc8a0e464a9696d6beb3c11c9b","show_url":"https://static-cluster-stage-preview.mobiapp.cloud/file/12719985/2023-04-18/ce4234bc8a0e464a9696d6beb3c11c9b?Expires=1681826097&OSSAccessKeyId=LTAI4G79M18aySHdG6xBUzNB&Signature=Jfd30qmxKECElWCGHpxMdGvQHio%3D","type":"DOCUMENT"}
 * {"name":"词云.jpg","oss_url":"https://mobi-app-pre-preview.oss-cn-hangzhou.aliyuncs.com/file/12719985/2023-04-18/3540b90cc8224701baf7d2492f532980","show_url":"https://static-cluster-stage-preview.mobiapp.cloud/file/12719985/2023-04-18/3540b90cc8224701baf7d2492f532980?Expires=1681826173&OSSAccessKeyId=LTAI4G79M18aySHdG6xBUzNB&Signature=PzlYJiDizFpnZ16Sj29jke7MAhY%3D","type":"IMAGE"}
 * {"name":"测试音频.mp3","oss_url":"https://mobi-app-pre-preview.oss-cn-hangzhou.aliyuncs.com/file/12719985/2023-04-18/d4a1c0a06f5a4be4a8b684457a00eb43","show_url":"https://static-cluster-stage-preview.mobiapp.cloud/file/12719985/2023-04-18/d4a1c0a06f5a4be4a8b684457a00eb43?Expires=1681826337&OSSAccessKeyId=LTAI4G79M18aySHdG6xBUzNB&Signature=6%2FhnkSZ9kBxnlX7p1c06DIVdMPg%3D","type":"AUDIO"}
 * {"name":"输入框问题.mov","oss_url":"https://mobi-app-pre-preview.oss-cn-hangzhou.aliyuncs.com/file/12719985/2023-04-18/8e7ca9d782d74d10a4c3d1fb463c48a9","show_url":"https://static-cluster-stage-preview.mobiapp.cloud/file/12719985/2023-04-18/8e7ca9d782d74d10a4c3d1fb463c48a9?Expires=1681826382&OSSAccessKeyId=LTAI4G79M18aySHdG6xBUzNB&Signature=7P349ZB%2Fr120NcAdgxrmyheSHK4%3D","type":"VIDEO"}
 * getDcValue ENUMERATION "Second"
 */

// 文件数据定义
export interface FileValue extends ConvertFromSchema<ResourceFileSchemaData> {
  name: string;
  url: string;
  alt?: string;
}

// 魔笔数据类型
export type VALUE =
  | BOOLEAN
  | TEXT
  | CHAR
  | INTEGER
  | LONG
  | DECIMAL
  | DATETIME
  | EnumValue
  | FileValue;

export type FILE_VALUE_TYPE = 'FILE' | 'DOCUMENT' | 'AUDIO' | 'VIDEO' | 'IMAGE';

export type VALUE_TYPE =
  | 'BOOLEAN'
  | 'TEXT'
  | 'CHAR'
  | 'INTEGER'
  | 'LONG'
  | 'DECIMAL'
  | 'ENUMERATION'
  | 'DATETIME'
  | FILE_VALUE_TYPE;
