import { VALUE } from './base-value';
import { AttrMeta, AssociationMeta, EntityMeta } from './meta';

// 实体对象定义
export interface EntityObject {
  id: string;
  dbId: string | undefined;
  get: <T extends VALUE>(attrMeta: AttrMeta) => T;
  set: (attrMeta: AttrMeta, value: VALUE) => void;
  delete: (object: EntityObject) => void;
  commit: (object: EntityObject) => void;
  addAssociation: (meta: AssociationMeta, target: EntityObject | EntityObject[]) => void;
  removeAssociation: (meta: AssociationMeta, target: EntityObject | EntityObject[]) => void;
  setAssociation: (meta: AssociationMeta, target: EntityObject | EntityObject[]) => void;
  getAssociatedObject: <T extends EntityObject | Array<EntityObject>>(
    meta: AssociationMeta,
  ) => T | undefined;
  meta: EntityMeta;
}
