import {
  DataSourceSchemaData,
  EntityAttrSchemaData,
  PageEventSchemaData,
  TemplateSchemaData,
} from '../schema/schema-data';
import { ConvertFromSchema } from './base';
import { EnumValue, VALUE_TYPE } from './base-value';
// 元数据定义
export interface AttrMeta extends ConvertFromSchema<EntityAttrSchemaData> {
  id: string;
  name: string;
  type: VALUE_TYPE;
  isSystemAttr: () => boolean;
  isAssociationAttr: () => this is AssociationAttrMeta;

  enumTypeId?: string;
  enums?: EnumValue[];
  contextData?: string;
}

export interface AssociationAttrMeta extends AttrMeta {
  getAssociationMeta: () => AssociationMeta | undefined;
  getAssociationEntityMeta: () => EntityMeta | undefined;
  getAssociationEntityAttrMeta: () => AttrMeta | undefined;
}

export type AttrMetaWith<Config> = Config & {
  field?: AttrMeta;
};

export type MultiAttrMetaWith<Config> = Array<AttrMetaWith<Config>>;
export type PackMultiAttrMetaWith<PackKey extends string, Config> = {
  [key in PackKey]?: MultiAttrMetaWith<Config>;
};

export interface EntityMeta {
  id: string;
  name: string;
  isSystemEntity: () => boolean;
  attrs: () => AttrMeta[];
}

export type DATA_SOURCE_TYPE = 'context' | 'database' | 'flow';

export interface DataSourceMeta extends ConvertFromSchema<DataSourceSchemaData> {
  type: DATA_SOURCE_TYPE;
  getDataMeta: () => EntityMeta;
  executeOnce: boolean;
  enableLoading: boolean;
}

export interface AssociationMeta {
  id: string;
}

export interface TemplateMeta extends ConvertFromSchema<TemplateSchemaData> {
  template: string;
  parameters?: string[];
}

export interface ActionMeta extends ConvertFromSchema<PageEventSchemaData> {
  noAction: () => boolean;
}

export interface LogicFlowMeta {}

export interface contextDataMeta {
  contextData: string;
}
