import { IconSchemaData, SizeSchemaData } from '../schema/schema-data';
import { ConvertFromSchema } from './base';
import api from '../index';

/* 样式数据定义 */
export interface Margin {
  marginLeft: string;
  marginRight: string;
  marginTop: string;
  marginBottom: string;
}

export interface Padding {
  paddingLeft: string;
  paddingRight: string;
  paddingTop: string;
  paddingBottom: string;
}

export interface Size extends ConvertFromSchema<SizeSchemaData> {
  toValue: (Margin?: Margin | string) => string | undefined;
}

export interface CustomSize<T> {
  type: 'preset' | 'customize';
  value:
    | T
    | {
        width: Size;
        height: Size;
      };
}

export function SizePercent(value: number = 100) {
  return api.convertSize({
    value,
    unit: '%',
  });
}

export function SizePx(value: number = 0) {
  return api.convertSize({
    value,
    unit: 'px',
  });
}

export function SizeAuto() {
  return api.convertSize({
    value: 0,
    unit: 'auto',
  });
}

export function SizeUnset() {
  return api.convertSize({
    value: 0,
    unit: 'unset',
  });
}

export interface IconMeta extends ConvertFromSchema<IconSchemaData> {
  component: React.ComponentType<any> | undefined;
  type: string;
  library: 'fusion' | 'b-design';
  title: string;
}
