import { PropGroup } from './prop';
import { PropRule } from './rule';

type Version = string;

type NeedUpgradeFunc = (from: Version, to: Version) => boolean;

export interface SchemaHandler {
  get: (key: string) => any;
  set: (key: string, value: any) => void;
  remove: (key: string) => void;
}

type UpgradeFunc = (from: Version, to: Version, handler: SchemaHandler) => boolean;

interface BaseConfig {
  // 平台版本，用于说明组件依赖的平台版本。平台可以利用此字段判断平台是否兼容此组件的实现
  apiVersion?: Version;
  // 组件版本，用于区分不同的组件props协议
  version?: Version;
  // 组件升级策略，用于执行组件props的版本升级
  upgrade?: NeedUpgradeFunc & UpgradeFunc;
}

export const PLATFORM_H5 = 'h5';
export const PLATFORM_PC = 'pc';
export const PLATFORM_MINI = 'mini';

export interface ComponentConfig extends BaseConfig {
  // 组件展示名
  title: string;
  // 组件的icon url
  icon: string;
  // 组件的唯一标识，似乎无用
  componentName: string;
  // 组件支持的平台
  supportPlatform?: Array<string>;
  // 组件分类 定义
  category: string;
  // 是否容器，内部是否允许配置children
  isContainer: boolean;
  // 数据配置器
  configure: Array<PropGroup>;
  // 错误检查规则
  rules: Array<PropRule>;
}
