import { FORMAT, PropRule } from './rule';

export const dataSourceRules = [
  {
    type: 'object',
    format: FORMAT.dataModelCheck,
    description: '绑定的数据源不存在/已更改，请重新绑定',
    propName: 'props.dataSource',
    level: 'ERROR',
    alias: '数据源',
  },
  {
    type: 'object',
    format: FORMAT.dataAssociationCheck,
    description: '绑定数据或组件层级已更改，该组件的上下文数据源已错误',
    propName: 'props.dataSource',
    level: 'ERROR',
    alias: '数据源',
  },
  {
    type: 'object',
    format: FORMAT.dataSourceFilter,
    description: '筛选字段不存在，请重新绑定',
    propName: 'props.dataSource.constraints.filter',
    level: 'ERROR',
    alias: '数据源',
  },
  {
    type: 'object',
    format: FORMAT.dataSourceSort,
    description: '排序字段不存在，请重新绑定',
    propName: 'props.dataSource.constraints.sort',
    level: 'ERROR',
    alias: '数据源',
  },
  {
    type: 'object',
    format: FORMAT.checkDatasourceSort,
    description: '数据源排序约束不合法',
    propName: 'props.dataSource',
    level: 'ERROR',
    alias: '数据源',
  },
  {
    type: 'object',
    format: FORMAT.checkDatasourceRange,
    description: '数据源范围约束不合法',
    propName: 'props.dataSource',
    level: 'ERROR',
    alias: '数据源',
  },
  {
    type: 'object',
    format: FORMAT.checkDatasourceFilter,
    description: '数据源筛选约束不合法',
    propName: 'props.dataSource',
    level: 'ERROR',
    alias: '数据源',
  },
  {
    type: 'object',
    format: FORMAT.contextDataCheck,
    description: '选择的数据不存在/已更改，请重新选择',
    propName: 'props.dataSource',
    level: 'ERROR',
    alias: '数据源',
  },
] as Array<PropRule>;
