interface TargetElement {
  getProps: () => {
    getPropValue: (propKey: string) => any;
  };
}

export interface PropConfig {
  // 属性名称
  name: string;
  // 属性标题
  title: string;
  display: 'inline' | 'block' | 'none';
  defaultValue?: any;
  setter: {
    // setter的类型
    type: string;
    // setter的props
    props: object;
  };
  condition?: (target: TargetElement) => boolean;
}

export interface PropGroup {
  title: string;
  type: 'group';
  display: 'block' | 'accordion';
  items: Array<PropConfig>;
}
