import { ArgType } from './mobi-type';

export enum FORMAT {
  // 组件是否在数据容器中
  isInDataContainer = 'isInDataContainer',
  // 判断 propName 不为空
  emptyCheck = 'emptyCheck',
  // 判断 绑定的上下文 是否存在
  contextDataCheck = 'contextDataCheck',
  // 判断字段是否和所在的数据容器的字段匹配。
  fieldCheck = 'fieldCheck',
  // 判断字段 和 逻辑流数据源的实体是否匹配
  logicResultCheck = 'logicResultCheck',
  // 判断 模板字符串 是否有误
  templateExpressionCheck = 'templateExpressionCheck',

  // 判断绑定的逻辑流 工作流是否存在
  logicCheck = 'logicCheck',
  // 判断事件绑定的逻辑流参数是否和逻辑流模型匹配
  logicParamsChangeCheck = 'logicParamsChangeCheck',
  // 判断事件绑定的工作流上下文是否是工作流对应的实体
  workFlowEnvCheck = 'workFlowEnvCheck',
  // 判断绑定的事件 如果是 外链 需要以http https 开头
  urlValidCheck = 'urlValidCheck',
  // 判断绑定的事件 页面传递的参数是否和逻辑流参数匹配
  logicPageParamCheck = 'logicPageParamCheck',
  // 判断绑定的事件，如果是内部跳转，不能跳转有自定义参数的页面
  eventCustomPathRouterCheck = 'eventCustomPathRouterCheck',
  // 判断事件 内部跳转 携带的上下文参数存在
  contextDataInsideJumpCheck = 'contextDataInsideJumpCheck',
  // 判断事件 内部跳转 页面存在
  insideJumpCheck = 'insideJumpCheck',

  // 判断上下文数据源 关联数据源是否存在
  dataAssociationCheck = 'dataAssociationCheck',
  // 检查数据源的实体模型是否存在，如果是逻辑流数据源，还判断逻辑流返回的实体模型是否匹配
  dataModelCheck = 'dataModelCheck',
  // 检查数据库数据源中过滤字段都在实体内有定义
  dataSourceFilter = 'dataSourceFilter',
  // 检查数据库数据源中排序字段都在实体内有定义
  dataSourceSort = 'dataSourceSort',
  // 判断数据库数据源 排序字段配置不对
  checkDatasourceSort = 'checkDatasourceSort',
  // 判断数据库数据源 范围字段配置不对
  checkDatasourceRange = 'checkDatasourceRange',
  // 判断数据库数据源 过滤字段配置不对
  checkDatasourceFilter = 'checkDatasourceFilter',
}

export interface logicPageParamCheckArgs {
  inject: Array<ArgType>;
}

export interface FormatObj {
  name: FORMAT; // 所使用的format
  args: any[]; // 当前format的额外参数,如{inject: [{type: 'TEXT'}]}
  condition?: string; // 当前format的condition,会替换整体condition
}

export interface PropRule {
  type: 'object';
  format: FORMAT | FormatObj; // 错误检查的类型
  description: string; // 错误信息
  propName?: string; // props.xxx
  alias?: string; // propName的别名，用于说明字段意图
  level: 'ERROR';
  condition?: string;
}
