/*

模型数据的定义

数据源
上下文 创建 单一数据
{"type":"context","entityName":"测试","entityId":"module_8pmozums::entity_zxxqcqod"}

上下文 对一关联
{"type":"context","entityName":"关联测试","entityId":"module_8pmozums::entity_ybfrrdib","associationId":"module_8pmozums::association_hwyzzm1e","associationType":"ONE_TO_ONE","parent":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_ybfrrdib"},"child":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_zxxqcqod"}}

上下文 对多关联
{"type":"context","entityName":"Child","entityId":"module_8pmozums::entity_jzdnveiu","associationId":"module_8pmozums::association_5ay95lys","associationType":"ONE_TO_MANY","parent":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_jzdnveiu"},"child":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_b0dvnsxd"}}
显示loading
{"type":"context","entityName":"Child","entityId":"module_8pmozums::entity_jzdnveiu","associationId":"module_8pmozums::association_5ay95lys","associationType":"ONE_TO_MANY","parent":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_jzdnveiu"},"child":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_b0dvnsxd"},"enableLoading":true}

逻辑流 单一数据
{"type":"flow","entityId":"module_8pmozums::entity_zxxqcqod","entityName":"测试","logicflowId":"module_8pmozums::flow_frontend_v8jhx8f9","logicflowParams":["测试"]}
显示loading 仅加载一次
{"type":"flow","entityId":"module_8pmozums::entity_zxxqcqod","entityName":"测试","logicflowId":"module_8pmozums::flow_frontend_v8jhx8f9","logicflowParams":["测试"],"enableLoading":true,"executeOnce":true}

逻辑流 多数据
{"type":"flow","entityId":"module_8pmozums::entity_zxxqcqod","entityName":"测试","logicflowId":"module_8pmozums::flow_frontend_phazviyc","logicflowParams":["搜索","分页"],"enableLoading":true,"executeOnce":true}

数据库 多数据
{"type":"database","entityName":"测试","entityId":"module_8pmozums::entity_zxxqcqod"}
增加配置
{"type":"database","entityName":"测试","entityId":"module_8pmozums::entity_zxxqcqod","constraints":{"filter":{"groups":[{"filter":[{"attrId":"id","dataType":"INTEGER","values":["1"],"type":"EQ"},{"attrId":"attr_l8k13uve","dataType":"TEXT","values":["哈哈"],"type":"CONTAINS"}],"type":"OR"}],"type":"AND"},"range":{"type":"custom","startIndex":"3","length":"20"},"sort":[{"attrId":"id","order":"asc","name":""},{"attrId":"attr_l8k13uvg","order":"desc","name":""}]},"enableLoading":true,"executeOnce":true}
{"type":"database","entityName":"测试","entityId":"module_8pmozums::entity_zxxqcqod","constraints":{"filter":{"groups":[{"filter":[{"attrId":"id","dataType":"INTEGER","values":["1"],"type":"EQ"},{"attrId":"attr_l8k13uve","dataType":"TEXT","values":["哈哈"],"type":"CONTAINS"}],"type":"OR"}],"type":"AND"},"range":{"type":"all"},"sort":[{"attrId":"id","order":"asc","name":""},{"attrId":"attr_l8k13uvg","order":"desc","name":""}]}}


字段
当前实体对象的字段
{"name":"char","attrId":"attr_l8k13uvd","description":"","dataType":"CHAR","required":true,"type":"CUSTOM","_mobi_field_":true}
当前实体对象关联对象的字段
{"name":"关联测试_测试/关联测试/name","attrId":"module_8pmozums::association_hwyzzm1e/module_8pmozums::entity_ybfrrdib/attr_l989azus","associationId":"module_8pmozums::association_hwyzzm1e","associationType":"ONE_TO_ONE","parent":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_ybfrrdib"},"child":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_zxxqcqod"},"description":"","dataType":"TEXT","required":true,"type":"CUSTOM","_mobi_field_":true}
枚举类型
{"name":"枚举","attrId":"attr_l9qj7fmn","enumerationId":"module_8pmozums::enum_yn1ihp9t","description":"","dataType":"ENUMERATION","required":false,"type":"CUSTOM","_mobi_field_":true,"enums":[{"value":"First"},{"value":"Second"},{"value":"Third"}]}
关联的枚举
{"name":"关联测试_测试/关联测试/longEnum","attrId":"module_8pmozums::association_hwyzzm1e/module_8pmozums::entity_ybfrrdib/attr_lgw7drko","associationId":"module_8pmozums::association_hwyzzm1e","associationType":"ONE_TO_ONE","parent":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_ybfrrdib"},"child":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_zxxqcqod"},"enumerationId":"module_8pmozums::enum_sojpqeyl","description":"","dataType":"ENUMERATION","required":false,"type":"CUSTOM","_mobi_field_":true,"enums":[{"value":"第一个枚举这么长"},{"value":"第二枚举值比第一枚举值长的很多很多"},{"value":"第三枚举值比其它枚举都长-长的超出你的想象-谁会定义这么长的枚举值-真是疯狂"}]}
时间字段
{"name":"修改时间","attrId":"modified_time","description":"【系统属性】数据修改时间","dataType":"DATETIME","required":true,"type":"SYSTEM","_mobi_field_":true}
关联时间
{"name":"关联测试_测试/关联测试/修改时间","attrId":"module_8pmozums::association_hwyzzm1e/module_8pmozums::entity_ybfrrdib/modified_time","associationId":"module_8pmozums::association_hwyzzm1e","associationType":"ONE_TO_ONE","parent":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_ybfrrdib"},"child":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_zxxqcqod"},"description":"【系统属性】数据修改时间","dataType":"DATETIME","required":true,"type":"SYSTEM","_mobi_field_":true}
数字字段
{"name":"integer","attrId":"attr_l8k13uvf","description":"","dataType":"INTEGER","required":true,"type":"CUSTOM","_mobi_field_":true}
{"name":"long","attrId":"attr_l8k13uvg","description":"","dataType":"LONG","required":true,"type":"CUSTOM","_mobi_field_":true}
{"name":"decimal","attrId":"attr_l8k13uvh","description":"","dataType":"DECIMAL","required":true,"type":"CUSTOM","_mobi_field_":true}
{"name":"关联测试_测试/关联测试/long","attrId":"module_8pmozums::association_hwyzzm1e/module_8pmozums::entity_ybfrrdib/attr_lgw7drkj","associationId":"module_8pmozums::association_hwyzzm1e","associationType":"ONE_TO_ONE","parent":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_ybfrrdib"},"child":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_zxxqcqod"},"description":"","dataType":"LONG","required":false,"type":"CUSTOM","_mobi_field_":true}
文件字段
{"name":"图片","attrId":"attr_l9gfzyq3","description":"","dataType":"IMAGE","required":false,"type":"CUSTOM","_mobi_field_":true}
{"name":"关联测试_测试/关联测试/图片","attrId":"module_8pmozums::association_hwyzzm1e/module_8pmozums::entity_ybfrrdib/attr_lgw7drkq","associationId":"module_8pmozums::association_hwyzzm1e","associationType":"ONE_TO_ONE","parent":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_ybfrrdib"},"child":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_zxxqcqod"},"description":"","dataType":"IMAGE","required":false,"type":"CUSTOM","_mobi_field_":true}

事件 
"module_8pmozums::page_5xcyranv" 
"http://www.baidu.com"
"close"
"submit"
"cancel"
"delete"
"call_frontflow_module_8pmozums::flow_frontend_979egtr9-表单两个实体"
"call_backendflow_module_8pmozums::flow_backend_wdpz71ol"
"userTaskPage"

静态文件
{"resourceId":"module_8pmozums::image_8mej6x6s","resourceName":"mobi_logo.png","resourceUrl":"https://mobi-app-prod-artifact.oss-cn-shanghai.aliyuncs.com/file/module_8pmozums/81440909caab45efa3e6169e41140544/mobi_logo.png?Expires=1682456167&OSSAccessKeyId=LTAI4GB2K86ZyjTYSAzS8p4y&Signature=BsoWqUlNH%2FIRaV5DWmH3rciiJDQ%3D"}

样式
宽
{"unit":"%","value":"98"}
{"unit":"px","value":100}
{"unit":"auto","value":100}

高
{"unit":"%","value":100}
{"unit":"px","value":100}
{"unit":"vh","value":100}
{"unit":"auto","value":100}

margin
{"marginLeft":"8px","marginRight":"8px","marginTop":"4px","marginBottom":"12px"}
{"marginLeft":"8px","marginRight":"8px","marginTop":"12px","marginBottom":"12px","paddingTop":"0px","paddingBottom":"4px","paddingLeft":"0px","paddingRight":"0px"}

图标
{"value":"edit","title":"编辑图标"}
{"value":"caret--down","origin":"b-design","title":"小箭头下"}
{"value":"unlock","title":"开锁图标"}
{"value":"home--outline","origin":"b-design","title":"主页图标"}

三级导航配置
[{"id":"5bd54a1d-7cc5-4294-98c7-406d4b344aaf","title":"临时","content":"module_8pmozums::page_lr0gkkic","level":1,"type":"page","icon":"column--filled"},{"id":"3b46c504-9ba0-4a3b-b05e-92f1b072c697","title":"组件测试","level":1,"type":"group","icon":""}]

关联
{"modelId":"module_8pmozums::entity_plhkvetx","modelName":"Year","associationId":"module_8pmozums::association_qpn9dmly","assocaitionName":"账号_Year","associationType":"ONE_TO_MANY","parent":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_4wkubs2h"},"child":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_plhkvetx"}}
多关联
[{"modelId":"module_8pmozums::entity_k5alzbwx","modelName":"child2","associationId":"module_8pmozums::association_vgq4zcsa","assocaitionName":"family2_child2","associationType":"MANY_TO_MANY","parent":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_17go8yai"},"child":{"cascadeType":"KEEP","entityId":"module_8pmozums::entity_k5alzbwx"}}]
*/
// 关联中两个节点的定义
export interface AssociationNodeSchemaData {
  cascadeType: string;
  entityId: string;
}

// 关联定义
export interface AssociationSchemaData {
  associationId: string;
  associationType: 'ONE_TO_ONE' | 'ONE_TO_MANY' | 'MANY_TO_MANY';
  parent: AssociationNodeSchemaData;
  child: AssociationNodeSchemaData;
}

// 逻辑流数据源中逻辑流的定义
export interface LogicFlowSchemaData {
  logicflowId: string;
  logicflowParams: string[];
}

// 数据库的约束条件
export interface DBConstraintSchemaData {
  filter: {
    groups: Array<{
      filter: Array<{
        attrId: string;
        dataType: string;
        values: string[];
        type: string;
      }>;
      type: string; // OR AND
    }>;
    type: string; // OR AND
  };
  range: {
    type: string; // custom all
    startIndex?: string;
    length?: string;
  };
  sort: Array<{
    attrId: string;
    order: string; // asc desc
    name: string;
  }>;
}

// 数据源基础字段
export interface BaseDataSourceSchemaData {
  type: string; // context  flow database
  entityName: string;
  entityId: string;
  enableLoading?: boolean;
  executeOnce?: boolean;
}

export interface ContextDataSchemaData {
  contextData: string;
}

export type ContextDataSourceSchemaData =
  | BaseDataSourceSchemaData
  | (BaseDataSourceSchemaData & AssociationSchemaData)
  | (BaseDataSourceSchemaData & AssociationSchemaData & ContextDataSchemaData);

// 数据源定义
export type DataSourceSchemaData =
  | BaseDataSourceSchemaData
  | (BaseDataSourceSchemaData & {
      constraints: DBConstraintSchemaData;
    })
  | ContextDataSourceSchemaData
  | (BaseDataSourceSchemaData & LogicFlowSchemaData);

// 基础字段定义
export interface BaseEntityAttrSchemaData {
  name: string;
  attrId: string;
  description: string;
  dataType: string; // DATETIME ENUMERATION TEXT INTEGER LONG DECIMAL IMAGE
  required: boolean;
  type: string; // CUSTOM SYSTEM
  _mobi_field_: boolean;
}

export interface EnumConfigSchemaData {
  enumerationId: string;
}

// 字段定义
export type EntityAttrSchemaData =
  | BaseEntityAttrSchemaData
  | (BaseEntityAttrSchemaData & ContextDataSchemaData)
  | (BaseEntityAttrSchemaData & AssociationSchemaData)
  | (BaseEntityAttrSchemaData & ContextDataSchemaData & AssociationSchemaData)
  | (BaseEntityAttrSchemaData & EnumConfigSchemaData)
  | (BaseEntityAttrSchemaData & ContextDataSchemaData & EnumConfigSchemaData)
  | (BaseEntityAttrSchemaData &
      ContextDataSchemaData &
      AssociationSchemaData &
      EnumConfigSchemaData);

export type AttrSchemaDataWith<Config> = Config & {
  field: EntityAttrSchemaData;
};

export type EditNameConfig = {
  name: string;
};

export type SearchTypeConfig = {
  searchType: string | boolean;
};

export type MultiAttrSchemaDataWith<Config> = Array<AttrSchemaDataWith<Config>> | undefined;

export type PackMultiAttrSchemaDataWith<PackKey extends string, Config> = {
  [key in PackKey]?: MultiAttrSchemaDataWith<Config>;
};

// 事件类型
export enum EventType {
  none = 'none',
  insideJump = 'inside_jump',
  outsideJump = 'outside_jump',
  submit = 'submit',
  cancel = 'cancel',
  delete = 'delete',
  callFrontflow = 'call_frontflow',
  callBackendflow = 'call_backendflow',
  callWorkflow = 'call_workflow',
  completeWorkflow = 'complete_workflow',
  openUserTaskpage = 'open_user_taskpage',
  close = 'close',
}

// web外部链接跳转方式
export enum WebJumpType {
  blank = 'blank',
  self = 'self',
}

// 小程序跳转方式
export enum MiniJumpType {
  redirectTo = 'redirectTo',
  navigateTo = 'navigateTo',
  switchTab = 'switchTab',
}

export interface MobiEventOptions {
  targetPage?: string; // 内部跳转,外部跳转
  target?: WebJumpType; // web外部链接跳转方式
  miniJumpType?: MiniJumpType; //小程序跳转方式
  ifCancel?: boolean; // 关闭页面
  onlyInMemory?: boolean; // 删除数据
  flowId?: string; // 调用逻辑流,调用工作流
  flowParams?: string[]; // 调用逻辑流,调用工作流
  userTaskNode?: string; // 完成用户任务
  taskResultNode?: string; // 完成用户任务
  contextData?: string | null; // 内部跳转携带的参数
}

export interface MobiEvent {
  type: EventType;
  options?: MobiEventOptions;
}

// 事件定义 这里MobiEvent的定义可能应该放在这里，然后toolkit来引用
export type PageEventSchemaData = string | MobiEvent;

// 静态资源文件
export interface ResourceFileSchemaData {
  resourceId: string;
  resourceName: string;
  resourceUrl?: string;
  _fallback_alt_?: string;
}

// 尺寸
export interface SizeSchemaData {
  unit: '%' | 'px' | 'auto' | 'vh' | 'calc' | 'unset' | 'rem';
  value: number | string;
}

export interface CustomSizeSchemaData<T> {
  type: 'preset' | 'customize';
  value:
    | T
    | {
        width: SizeSchemaData;
        height: SizeSchemaData;
      };
}

// 图标定义
export type IconSchemaData =
  | string
  | { value: string; title: string }
  | { value: string; origin: string; title: string };

// 导航定义
export interface NavItemSchemaData {
  id: string;
  title: string;
  content: string;
  level: number;
  type: string; // "page"
  icon: string;
}

export type BooleanSchemaData = boolean;
export type CharTextSchemaData = string;
export type IntegerLongDecimalSchemaData = number;

// 当前 DATETIME 枚举 没有定义 模型数据
export type StaticValueSchemaData =
  | ResourceFileSchemaData
  | BooleanSchemaData
  | CharTextSchemaData
  | IntegerLongDecimalSchemaData;

export interface TemplateSchemaData {
  template: string;
  parameters?: string[];
}

export type AttrValueSchemaData = StaticValueSchemaData | EntityAttrSchemaData | TemplateSchemaData;

// 这里是setter-layout 生成的模型定义
export interface PageLayoutSchemaData {
  type: 'normal' | 'popup';
  position: 'center' | 'left' | 'right' | 'top' | 'bottom';
  autoClose: boolean;
  dynamic?: boolean;
  style: {
    [key: string]: string;
  };
  copyMode: boolean;
}
