import {
  AttrValueSchemaData,
  BooleanSchemaData,
  CharTextSchemaData,
  IntegerLongDecimalSchemaData,
  ResourceFileSchemaData,
  StaticValueSchemaData,
  TemplateSchemaData,
  EntityAttrSchemaData,
} from './schema-data';

export const isBasicTypeSchemaData = (
  propValue: AttrValueSchemaData,
): propValue is BooleanSchemaData | CharTextSchemaData | IntegerLongDecimalSchemaData =>
  typeof propValue === 'number' || typeof propValue === 'boolean' || typeof propValue === 'string';

export const isResourceFileSchemaData = (
  propValue: AttrValueSchemaData,
): propValue is ResourceFileSchemaData =>
  typeof propValue === 'object' &&
  (((propValue as ResourceFileSchemaData).resourceId &&
  (propValue as ResourceFileSchemaData).resourceName
    ? true
    : false) ||
    ((propValue as ResourceFileSchemaData).resourceUrl ? true : false));

export const isValueSchemaData = (propValue: AttrValueSchemaData): propValue is StaticValueSchemaData =>
  isBasicTypeSchemaData(propValue) || isResourceFileSchemaData(propValue);

export const isTemplateSchemaData = (
  propValue: AttrValueSchemaData,
): propValue is TemplateSchemaData =>
  typeof propValue === 'object' && (propValue as TemplateSchemaData).template ? true : false;

export const isAttrSchemaData = (
  propValue: AttrValueSchemaData,
): propValue is EntityAttrSchemaData =>
  typeof propValue === 'object' && (propValue as EntityAttrSchemaData).attrId ? true : false;
