import React from 'react';
import Kalend, { CalendarView, CalendarEvent } from 'kalend'; // import component
import 'kalend/dist/styles/index.css'; // import styles
import './index.less';
import { Balloon as Popover } from '@alifd/next';

interface Props {
  events: CalendarEvent[];
}

const Event = (props: any) => {
  const content = (
    <div
      style={{
        width: '100%',
        minHeight: '20px',
        ...(props.type === 'day' ? { height: '100%' } : {}),
        zIndex: 9998,
        display: 'flex',
        alignItems: 'center',
      }}
    >
      <p
        style={{
          fontSize: props.type === 'day' ? 10 : 10,
          ...(props.summary && props.summary.endsWith('取消')
            ? { textDecoration: 'line-through' }
            : {}),
        }}
      >
        {props.summary}
      </p>
    </div>
  );

  return (
    <Popover align="t" v2 trigger={content} closable={false}>
      {props.describe ? props.describe : ``}
    </Popover>
  );
};

function EventCalendar(props: Props) {
  const { events } = props;

  return (
    <div className={`calendar`}>
      <Kalend
        events={
          (events &&
            events.map((event) => {
              const summary = event.summary;
              const describe = event.describe;
              return {
                ...event,
                children: {
                  daysView: <Event summary={summary} describe={describe} type={'day'} />,
                  monthView: <Event summary={summary} describe={describe} type={'month'} />,
                },
              };
            })) ||
          []
        }
        initialDate={new Date().toISOString()}
        hourHeight={60}
        initialView={CalendarView.MONTH}
        selectedView={CalendarView.MONTH}
        disabledDragging
        timeFormat={'24'}
        weekDayStart={'Monday'}
        language={'zh'}
        autoScroll
      />
    </div>
  );
}

export default EventCalendar;
