import {
  API_VERSION,
  Category,
  ComponentConfig,
  FORMAT,
  PLATFORM_H5, PLATFORM_PC,
  actionRules,
  attrRules,
  dataSourceRules
} from './api';

const config: ComponentConfig = {
  apiVersion: API_VERSION,
  version: '1.0',
  isContainer: false,
  title: '',
  componentName: 'MobiPcEventCalender',
  supportPlatform: [PLATFORM_PC, PLATFORM_H5],
  category: Category.COMMON,
  icon: 'https://img.alicdn.com/imgextra/i1/O1CN01oufFHB266LbYRkVr3_!!6000000007612-55-tps-20-20.svg',
  configure: [
    {
      title: '属性',
      type: 'group',
      display: 'block',
      items: [
      ],
    },
    {
      title: '样式',
      type: 'group',
      display: 'block',
      items: [
        {
          name: 'width',
          title: '宽度',
          display: 'block',
          defaultValue: {
            value: 100,
            unit: '%',
          },
          setter: {
            type: 'new-size-setter',
            props: {
              defaultValueForTabs: [{ unit: '%', value: 100 }],
            },
          },
        },
        {
          name: 'height',
          title: '宽度',
          display: 'block',
          defaultValue: {
            value: 100,
            unit: '%',
          },
          setter: {
            type: 'new-size-setter',
            props: {
              defaultValueForTabs: [{ unit: '%', value: 100 }],
            },
          },
        },
        {
          name: 'margin',
          title: '间距',
          display: 'block',
          defaultValue: {
            marginLeft: '8px',
            marginRight: '8px',
            marginTop: '12px',
            marginBottom: '12px',
          },
          setter: {
            type: 'margin-padding',
            props: {
              paddingDisable: true,
            },
          },
        },
      ],
    },
    {
      title: '数据',
      type: 'group',
      display: 'block',
      items: [
        {
          name: 'dataSource',
          title: '数据源',
          display: 'block',
          setter: {
            type: 'data-table',
            props: {
              materialProp: 'dataSource',
              options: [],
              changeClear: true,
            },
          },
        },
        {
          name: 'isDataComponent',
          title: '是否为数据容器',
          display: 'none',
          defaultValue: true,
          setter: {
            type: 'bool',
            props: {},
          },
        },
        {
          name: 'DataType',
          title: '数据容器类型',
          display: 'none',
          defaultValue: 'List-Data',
          setter: {
            type: 'text',
            props: {},
          },
        },
        {
          name: 'eventStart',
          title: '选择事件起始时间字段',
          display: 'block',
          setter: {
            type: 'data-bind-field',
            props: {
              materialProp: 'eventStart',
              supportFieldType: ['datetime'],
              booleanTransformList: true,
            },
          },
        },
        {
          name: 'eventEnd',
          title: '选择事件结束时间字段',
          display: 'block',
          setter: {
            type: 'data-bind-field',
            props: {
              materialProp: 'eventEnd',
              supportFieldType: ['datetime'],
              booleanTransformList: true,
            },
          },
        },
        {
          name: 'eventSummary',
          title: '选择事件描述字段',
          display: 'block',
          setter: {
            type: 'data-bind-field',
            props: {
              materialProp: 'eventSummary',
              supportFieldType: ['text', 'char'],
              booleanTransformList: true,
            },
          },
        },
        {
          name: 'eventDescribe',
          title: '选择事件tips展示字段',
          display: 'block',
          setter: {
            type: 'data-bind-field',
            props: {
              materialProp: 'eventSummary',
              supportFieldType: ['text', 'char'],
              booleanTransformList: true,
            },
          },
        },
      ],
    },
  ],

  rules: [
    {
      type: 'object',
      format: FORMAT.emptyCheck,
      description: '数据源不能为空',
      propName: 'props.dataSource',
      alias: '数据源',
      level: 'ERROR',
    },
    ...dataSourceRules,
  ],
};

export default config;
