import EventCalendar from './component';
import { CalendarEvent } from 'kalend'; // import component
import React, { useEffect, useRef, useState } from 'react';
import api, {
  AttrMeta,
  EntityObject,
  Margin,
  PropsWithPageContext,
  Size,
  SizePercent,
} from './api';
import config from './config';
import './index.scss';

interface Props {
  width: Size;
  height: Size;
  margin: Margin;
  eventStart: AttrMeta;
  eventEnd: AttrMeta;
  eventDescribe: AttrMeta;
  eventSummary: AttrMeta;
}

const MobiPcEventCalender = (props: PropsWithPageContext<Props>) => {
  const {
    width = SizePercent(100),
    height = SizePercent(100),
    margin = {
      marginLeft: '8px',
      marginRight: '8px',
      marginTop: '12px',
      marginBottom: '12px',
    },
    eventDescribe,
    eventEnd,
    eventStart,
    eventSummary,
    pageContext,
  } = props;

  const style = {
    width: width.toValue(margin),
    height: height.toValue(margin),
    ...margin,
  };

  if (!api.isPreview()) {
    return (
      <div style={style}>
        <EventCalendar events={[]}></EventCalendar>
      </div>
    );
  } else {
    const dataSourceApi = pageContext.getDataSource();
    dataSourceApi.processDataSource();
    const entityList = pageContext.getData<EntityObject[]>() || [];

    let events: CalendarEvent[] = [];

    events = entityList.map((entityObject) => {
      const startAt = entityObject.get<Date>(eventStart);
      let endAt = entityObject.get<Date>(eventEnd);
      const describe = entityObject.get<string>(eventDescribe);
      const summary = entityObject.get<string>(eventSummary);

      // if (startAt === endAt) {
      //   endAt = new Date(endAt.getTime() + 5 * 3600000);
      // }

      return {
        id: entityObject.id,
        startAt:
          startAt && startAt instanceof Date ? startAt.toISOString() : new Date().toISOString(),
        endAt: endAt && endAt instanceof Date ? endAt.toISOString() : new Date().toISOString(),
        summary,
        describe,
        color: '#5584ff',
      };
    });

    return (
      <div style={style}>
        <EventCalendar events={events}></EventCalendar>
      </div>
    );
  }
};
MobiPcEventCalender.config = config;

export default MobiPcEventCalender;
